<?php
/*
Plugin Name: Mollie Forms User Creator
Description: Maakt automatisch WordPress gebruikers aan vanuit Mollie Forms inschrijvingen.
Version: 1.0.4
Author: vanMeerdervoort
*/

if (!defined('ABSPATH')) exit;

// Plugin constants
define('MFUC_VERSION', '1.0.4');
define('MFUC_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('MFUC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('MFUC_PLUGIN_BASENAME', plugin_basename(__FILE__));

// Check if Mollie Forms is active
add_action('admin_init', 'mfuc_check_mollie_forms');
function mfuc_check_mollie_forms() {
    if (!class_exists('MollieForms\MollieForms')) {
        add_action('admin_notices', 'mfuc_mollie_forms_missing_notice');
    }
}

function mfuc_mollie_forms_missing_notice() {
    ?>
    <div class="notice notice-error">
        <p><?php _e('Mollie Forms User Creator vereist de Mollie Forms plugin. Installeer en activeer eerst Mollie Forms.', 'mollie-forms-user-creator'); ?></p>
    </div>
    <?php
}

// Include required files
$includes_dir = MFUC_PLUGIN_DIR . 'includes/';
if (file_exists($includes_dir . 'user-creator.php')) {
    require_once $includes_dir . 'user-creator.php';
}
if (file_exists($includes_dir . 'hooks.php')) {
    require_once $includes_dir . 'hooks.php';
}
if (file_exists($includes_dir . 'admin-settings.php')) {
    require_once $includes_dir . 'admin-settings.php';
}

// Activation/Deactivation hooks
register_activation_hook(__FILE__, 'mfuc_activate');
register_deactivation_hook(__FILE__, 'mfuc_deactivate');

function mfuc_activate() {
    global $wpdb;
    
    // Create database table for logging (optional)
    $charset_collate = $wpdb->get_charset_collate();
    
    $table_log = $wpdb->prefix . 'mfuc_user_creation_log';
    $sql_log = "CREATE TABLE IF NOT EXISTS $table_log (
        id INT AUTO_INCREMENT PRIMARY KEY,
        form_id BIGINT(20) NOT NULL,
        registration_id BIGINT(20) NOT NULL,
        user_id BIGINT(20) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        status VARCHAR(20) DEFAULT 'created',
        notes TEXT
    ) $charset_collate;";
    
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql_log);
}

function mfuc_deactivate() {
    // Cleanup if needed
}

// Update system
add_filter('pre_set_site_transient_update_plugins', 'mfuc_check_for_updates');
function mfuc_check_for_updates($transient) {
    if (empty($transient->checked)) return $transient;
    
    $remote = wp_remote_get('https://plugins.nietstezienhier.nl/mollie-forms-user-creator/update.json', [
        'timeout' => 15,
        'sslverify' => false,
    ]);
    
    if (is_wp_error($remote) || wp_remote_retrieve_response_code($remote) !== 200) {
        return $transient;
    }
    
    $plugin_data = json_decode(wp_remote_retrieve_body($remote));
    if (!$plugin_data) return $transient;
    
    $plugin_file = MFUC_PLUGIN_BASENAME;
    $current_version = $transient->checked[$plugin_file] ?? null;
    
    if ($current_version && version_compare($plugin_data->version, $current_version, '>')) {
        $transient->response[$plugin_file] = (object)[
            'slug' => $plugin_data->slug,
            'new_version' => $plugin_data->version,
            'url' => $plugin_data->homepage,
            'package' => $plugin_data->download_url,
        ];
    }
    
    return $transient;
}

add_filter('plugins_api', 'mfuc_plugin_info', 10, 3);
function mfuc_plugin_info($result, $action, $args) {
    if ($action !== 'plugin_information' || $args->slug !== 'mollie-forms-user-creator') {
        return $result;
    }
    
    $remote = wp_remote_get('https://plugins.nietstezienhier.nl/mollie-forms-user-creator/update.json', [
        'timeout' => 15,
        'sslverify' => false,
    ]);
    
    if (is_wp_error($remote) || wp_remote_retrieve_response_code($remote) !== 200) {
        return $result;
    }
    
    $plugin_data = json_decode(wp_remote_retrieve_body($remote));
    if (!$plugin_data) return $result;
    
    return (object)[
        'name' => $plugin_data->name,
        'slug' => $plugin_data->slug,
        'version' => $plugin_data->version,
        'author' => $plugin_data->author,
        'homepage' => $plugin_data->homepage,
        'sections' => (array) $plugin_data->sections,
        'download_link' => $plugin_data->download_url,
    ];
}


