# Debugging BookingPress Access Codes Plugin

## Error Logs Locaties

### WordPress Debug Log
Als `WP_DEBUG_LOG` is ingeschakeld in `wp-config.php`, worden errors gelogd in:
- `wp-content/debug.log`

Om dit in te schakelen, voeg toe aan `wp-config.php`:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

### PHP Error Log
Standaard PHP error log locaties:
- Linux: `/var/log/php_errors.log` of `/var/log/apache2/error.log`
- Windows: Check PHP configuratie
- cPanel: Meestal in `~/public_html/error_log` of via cPanel > Error Log

### Server Error Logs
- Apache: `/var/log/apache2/error.log` of `/var/log/httpd/error_log`
- Nginx: `/var/log/nginx/error.log`
- cPanel: Via cPanel > Error Log

## Debug Informatie in Plugin

De plugin logt nu uitgebreide debug informatie naar de error log. Zoek naar regels die beginnen met `BPAC DEBUG:`.

### Wat wordt gelogd:
1. **Bij update**: Room ID, access code waarde, query resultaat, opgeslagen waarde
2. **Bij ophalen**: Aantal rooms, per room de access_code waarde

### Logs bekijken:

**Via SSH:**
```bash
tail -f /path/to/error.log | grep "BPAC DEBUG"
```

**Via cPanel:**
- Ga naar cPanel > Error Log
- Filter op "BPAC DEBUG"

**Via WordPress:**
- Installeer een plugin zoals "Error Log Viewer"
- Of check `wp-content/debug.log` als WP_DEBUG_LOG is ingeschakeld

## Test Stappen

1. Schakel WP_DEBUG_LOG in (zie boven)
2. Probeer een code op te slaan
3. Check de error log voor `BPAC DEBUG:` regels
4. Deel de relevante log regels voor analyse

