# WordPress Cron (WP-Cron) Informatie

## Hoe WP-Cron werkt

**Belangrijk**: WordPress Cron (WP-Cron) is **niet** een echte cron job. Het draait alleen wanneer er een bezoeker op je website komt.

### Hoe het werkt:
1. Wanneer een bezoeker je website bezoekt, controleert WordPress of er geplande taken zijn die moeten draaien
2. Als er taken zijn die moeten draaien, worden ze uitgevoerd
3. Als er geen bezoekers zijn, worden de taken **niet** uitgevoerd

### Voor dit plugin:
- De dagelijkse verzending wordt alleen uitgevoerd als er op het ingestelde tijdstip (of later) een bezoeker komt
- Als er geen bezoekers zijn om 08:00, wordt de taak uitgevoerd zodra de eerste bezoeker daarna komt
- Dit kan betekenen dat e-mails later worden verzonden dan gepland

## Echte Cron Job Instellen (Aanbevolen)

Voor betrouwbare timing kun je een echte cron job instellen via je hosting provider of server.

### Via cPanel:
1. Ga naar cPanel > Cron Jobs
2. Voeg een nieuwe cron job toe:
   ```
   */15 * * * * wget -q -O - https://jouwsite.nl/wp-cron.php?doing_wp_cron >/dev/null 2>&1
   ```
   Dit controleert elke 15 minuten of er taken zijn.

### Via SSH:
Voeg toe aan crontab (`crontab -e`):
```bash
*/15 * * * * curl -s https://jouwsite.nl/wp-cron.php?doing_wp_cron >/dev/null 2>&1
```

### Alternatief: Directe WP-Cron trigger
Je kunt ook een cron job instellen die direct de plugin functie aanroept:
```bash
*/15 * * * * curl -s https://jouwsite.nl/wp-admin/admin-ajax.php?action=bpac_trigger_send >/dev/null 2>&1
```
(Hiervoor moet je wel een AJAX endpoint toevoegen aan de plugin)

## Testen of WP-Cron werkt

1. Ga naar WordPress Admin > Tools > Site Health > Info > Cron Events
2. Zoek naar `bpac_daily_send_codes`
3. Check of het gepland staat en wanneer het volgende keer draait

## Aanbeveling

Voor productie websites met belangrijke timing (zoals toegangscodes), is het **sterk aanbevolen** om een echte cron job in te stellen die elke 15 minuten `wp-cron.php` aanroept.

